function [beta_final,lamda_error,fval_out,min_vector] = L2(train_in,test_in,log2lamda_in)

% Using quadprog in L2 norm
% Read in the training, tuning, testing and log2lamda data
% It works for k = 2 or 3 or 4 or 5

    global k;
    global d;
    global d1;
    
    % get input argument
    train = train_in;
    train_data = train(:,2:end);
    [row_train,col_train] = size(train_data);
    log2lamda = log2lamda_in;
    num_lamda = length(log2lamda);
    my_lamda = power(2,log2lamda);   

    % initialize output argument and others
    beta_all = zeros(1+k*d+row_train+1,num_lamda);
    beta_final = zeros(1+k*d,num_lamda);
    lamda_error = zeros(num_lamda,5); % have 5 columns: log2lamda,error,exit_flag,#iterations,minimum
    lamda_error(:,1) = log2lamda;
    
    % generate A matrix
    data1 = [train(:,1), repmat(train_data, 1, k), ones(row_train,row_train)];
    data1_data = data1(:,2:end);
    A = []; % A[k*row_train,k*d+row_train] 
    b = []; % b[k*row_train,1]
    for i = 1:row_train
      label = data1(i,1);
      for j = 1:k 
        if label==j
            temp = zeros(1,k*d+row_train);
            temp(1,k*d+i) = -1;
            A = [A; data1_data(i,:).*temp];
            b = [b;0];
        else
            temp = zeros(1,k*d+row_train);
            temp(1,(j-1)*d+1:j*d) = 1;
            temp(1,(label-1)*d+1:label*d) = -1;
            temp(1,k*d+i) = -1;
            A = [A; data1_data(i,:).*temp];
            b = [b;-1];
        end
      end
    end    
    A = sparse(A);
    
    % sum to zeros constraints

    diag_vec = ones(d,1);
    temp = diag(diag_vec);
    Aeq = [repmat(temp,1,k),zeros(d,row_train)];
    beq = zeros(d,1);

    %%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%  
    A = [A;Aeq];
    b_U = [b;beq];
    temp = -inf;
    b2 = repmat(temp,size(b));
    b_L = [b2;beq];
    %%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%

    lb = [];
    ub = [];
    xstart = [];    

    options = optimset('LargeScale','off','display','on','MaxIter',10000);

    for i = 1:num_lamda

        pre_H = [zeros(1,1);ones(d1,1)];
        diag_vec = [repmat(pre_H,k,1);zeros(row_train,1)]*my_lamda(i,1);
        H = diag(diag_vec);
        H = sparse(H); % H[k*d+row_train,k*d+row_train] diagonal matrix       
        f = [zeros(k*d,1);ones(row_train,1)];
        
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        Name = 'qpQG'; % Problem name, not required.

        Prob = qpAssign(H,f, A, b_L, b_U, lb, [], []);

        Result = tomRun('sqopt', Prob, 0);

        x = Result.x_k;
        fvalue = Result.f_k;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        

        beta_all(:,i) = [log2lamda(i,1);x;fvalue];
        beta = x(1:k*d);
        beta_final(:,i) = [log2lamda(i,1);beta];
        
        lamda_error(i,3) = Result.ExitFlag;
        lamda_error(i,4) = Result.Iter;
        
        % testing on the tune data set
        [fval,tune_error] = test(beta,test_in);               
        lamda_error(i,2) = tune_error;
       
    end

    [Y,index] = min(lamda_error(:,2));
    lamda_error(:,5) = 0;
    lamda_error(index,5) = 1;

    % testing on the testing data set
    [fval,test_error] = test(beta_all(2:k*d+1,index),test_in);               
    fval_out = fval;
    min_vector = [log2lamda(index);my_lamda(index);test_error;lamda_error(index,3);beta_all(2:end,index);];
    
